from . import hebi_conn
from . import hebi_proto


def create_module_connection(ip_addr):
  """
  Create a new module connection from the given ip address.

  This function does not check if a module with the provided IP address actually exists on any local network.
  """
  udp_conn = hebi_conn.UdpConnection(ip_addr)
  return hebi_conn.ModuleConnection(udp_conn)


def create_module_server(port = None):
  """
  Create a new module server (e.g., we can act like a real module, and respond to lookup and feedback
  requests from Scope and the APIs)
  """
  udp_conn = hebi_conn.UdpServerConnection(port = port)
  return hebi_conn.ModuleConnection(udp_conn)


def new_root_message():
  """
  Allocates a new RootMessage
  """
  return hebi_proto.RootMessage()

